DROP PROCEDURE [hips].[ClinicalDocumentVersionUpdate]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date: 16 Nov 2012
-- Description:   Updates a record in the ClinicalDocumentVersion table - during a supersede or remove
-- 06/12/2012 - sbiber - Removed removal information (moved to ClinicalDocument table)
-- 16/06/2013 - sbiber - Changed set ID length from 50 to 128
-- =============================================
CREATE PROCEDURE [hips].[ClinicalDocumentVersionUpdate] 
(
	--hips fields
	@ClinicalDocumentVersionId INT,
	@ClinicalDocumentId INT,
	@SourceSystemDocumentId varchar(128),
	@UploadedDate DATETIME = null,
	@SupersededDate datetime = null,
	@Package varbinary(MAX),
	@UserModified varchar(256),
	@DateModified datetime
	
)
AS
BEGIN
    SET NOCOUNT ON

    DECLARE @intErrorCode INT


    SET @intErrorCode = 0
    IF NOT EXISTS (SELECT TOP 1 [DateModified]
            	FROM [hips].[ClinicalDocumentVersion]
				WHERE [ClinicalDocumentVersionId] = @ClinicalDocumentVersionId AND [DateModified] = @DateModified)
    BEGIN
        RAISERROR 50001 'Record has already been updated!'
        SET @intErrorCode = @@ERROR
    END
 IF @intErrorCode = 0
    BEGIN

		update
		[hips].[ClinicalDocumentVersion]
		set
          [SourceSystemDocumentId] = @SourceSystemDocumentId
         , [ClinicalDocumentId] = @ClinicalDocumentId
         , [UploadedDate] = @UploadedDate
         , [SupersededDate] = @SupersededDate
         , [Package] = @Package
         , [DateModified] = GetDate()
         , [UserModified] = @UserModified
		where ClinicalDocumentVersionId = @ClinicalDocumentVersionId

    
    SELECT @intErrorCode = @@ERROR 
    end
	
    IF @intErrorCode = 0
    BEGIN
        SELECT [ClinicalDocumentVersionId]
         , [ClinicalDocumentId]
		 , [SourceSystemDocumentId]
         , [UploadedDate]
         , [SupersededDate]
         , [Package]
         , [DateCreated]
         , [UserCreated]
         , [DateModified]
         , [UserModified]
         FROM [hips].[ClinicalDocumentVersion]
         WHERE [ClinicalDocumentVersionId] = @ClinicalDocumentVersionId
   end
   RETURN(@intErrorCode)
END
GO

